# tkinter_map.py
import tkinter as tk
from config import *

class PatrolMap:
    def __init__(self, root):
        self.canvas = tk.Canvas(root, width=WIDTH, height=HEIGHT, bg="#222")
        self.canvas.pack()
        self.entities = {} # Store refs to the circles
        self.draw_obstacles()

    def draw_obstacles(self):
        """Draw the subway station environment."""
        for obs in OBSTACLES:
            if obs["type"] == "pillar":
                self.canvas.create_rectangle(
                    obs["x"], obs["y"], obs["x"] + obs["w"], obs["y"] + obs["h"],
                    fill="#444", outline="#666", width=2
                )
            elif obs["type"] == "platform":
                self.canvas.create_rectangle(
                    obs["x"], obs["y"], obs["x"] + obs["w"], obs["y"] + obs["h"],
                    fill="#555", outline="#888", width=2
                )
            elif obs["type"] == "barrier":
                self.canvas.create_rectangle(
                    obs["x"], obs["y"], obs["x"] + obs["w"], obs["y"] + obs["h"],
                    fill="#333", outline="#555", width=1
                )
        
        # Draw spawn entrance markers
        for spawn in RESISTANCE_SPAWNS:
            self.canvas.create_text(
                spawn["x"], spawn["y"], 
                text="⚠", fill="red", font=("Arial", 16, "bold")
            )

    def draw_unit(self, unit_id, x, y, body_color, outline_color):
        # Draw the outer ring (The "Overwatch" or "Yellow" circle)
        self.canvas.create_oval(x-8, y-8, x+8, y+8, outline=outline_color, width=2, tags=f"ring_{unit_id}")
        # Draw the inner dot
        self.canvas.create_oval(x-4, y-4, x+4, y+4, fill=body_color, tags=f"body_{unit_id}")

    def update_position(self, unit_id, x, y):
        # Move both the body and the ring
        self.canvas.coords(f"ring_{unit_id}", x-8, y-8, x+8, y+8)
        self.canvas.coords(f"body_{unit_id}", x-4, y-4, x+4, y+4)
