#!/bin/bash

# Create the project directory
mkdir -p CO_PATROL_SIM
cd CO_PATROL_SIM

# 1. Create config.py
cat <<EOF > config.py
WIDTH = 800
HEIGHT = 600
NUM_THREADS = 24

# Colors
COLOR_COMBINE_BODY = "black"
COLOR_COMBINE_OUTLINE = "white"
COLOR_CP_BODY = "blue"
COLOR_CP_OUTLINE = "cyan"
COLOR_RESISTANCE_BODY = "blue"
COLOR_RESISTANCE_OUTLINE = "yellow"
EOF

# 2. Create tkinter_map.py
cat <<EOF > tkinter_map.py
import tkinter as tk
from config import *

class PatrolMap:
    def __init__(self, root):
        self.canvas = tk.Canvas(root, width=WIDTH, height=HEIGHT, bg="#222")
        self.canvas.pack()

    def draw_unit(self, unit_id, x, y, body_color, outline_color):
        self.canvas.create_oval(x-8, y-8, x+8, y+8, outline=outline_color, width=2, tags=f"ring_{unit_id}")
        self.canvas.create_oval(x-4, y-4, x+4, y+4, fill=body_color, tags=f"body_{unit_id}")

    def update_position(self, unit_id, x, y):
        self.canvas.coords(f"ring_{unit_id}", x-8, y-8, x+8, y+8)
        self.canvas.coords(f"body_{unit_id}", x-4, y-4, x+4, y+4)
EOF

# 3. Create combat_log.py
cat <<EOF > combat_log.py
import struct
DATA_FORMAT = "qqqq" 

class CombatLogger:
    def __init__(self, filename="patrol_data.bin"):
        self.filename = filename

    def log_event(self, timestamp, unit_id, event_code, value):
        with open(self.filename, "ab") as f:
            binary_data = struct.pack(DATA_FORMAT, int(timestamp), int(unit_id), int(event_code), int(value))
            f.write(binary_data)
EOF

# 4. Create skirmish.py
cat <<EOF > skirmish.py
import random
class SkirmishEngine:
    def assume_position(self, last_x, last_y, vx, vy):
        return last_x + (vx * 3), last_y + (vy * 3)
EOF

# 5. Create combine_overwatch.py
cat <<EOF > combine_overwatch.py
import random
class EliteUnit:
    def __init__(self, uid, x, y):
        self.id = uid
        self.x, self.y = x, y
    def get_movement(self):
        return random.randint(-1, 1), random.randint(-1, 1)
    def receive_report(self, node):
        print(f"Elite {self.id} received intel on {node['pos']}")
EOF

# 6. Create civil_protection.py
cat <<EOF > civil_protection.py
import random
class CivilProtection:
    def __init__(self, uid, x, y):
        self.id = uid
        self.x, self.y = x, y
        self.is_eager = True
        self.intel_nodes = [{"pos": (100, 100)}]
    def patrol_logic(self):
        return random.randint(-3, 3), random.randint(-3, 3)
    def encounter_elite(self, elite):
        if self.intel_nodes:
            for node in self.intel_nodes:
                elite.receive_report(node)
            self.intel_nodes = []
EOF

# 7. Create resistance.py
cat <<EOF > resistance.py
import random
class RebelUnit:
    def __init__(self, uid, x, y):
        self.id = uid
        self.x, self.y = x, y
    def get_movement(self):
        return random.randint(-5, 5), random.randint(-5, 5)
EOF

# 8. Create log_reader.py
cat <<EOF > log_reader.py
import struct
DATA_FORMAT = "qqqq"
ENTRY_SIZE = struct.calcsize(DATA_FORMAT)
def read():
    try:
        with open("patrol_data.bin", "rb") as f:
            while chunk := f.read(ENTRY_SIZE):
                print(struct.unpack(DATA_FORMAT, chunk))
    except: pass
if __name__ == "__main__": read()
EOF

# 9. Final main.py (The Orchestrator)
# [Note: Reusing the main.py logic provided in the previous step]

echo "Deployment complete. Run 'python3 main.py' to start the simulation."
