import psutil
import time
import os
from config import NUM_THREADS

class PerformanceMonitor:
    def __init__(self):
        self.num_cores = psutil.cpu_count(logical=True)
        self.process = psutil.Process(os.getpid())

    def get_stats(self):
        """
        Gathers CPU usage percentage for every logical thread.
        On your Xeon, this will return 24 distinct values.
        """
        # Get usage per core over a short interval
        per_core_usage = psutil.cpu_percent(interval=None, percpu=True)
        
        # Total memory usage of the simulation
        mem_info = self.process.memory_info().rss / (1024 * 1024) # Convert to MB
        
        return per_core_usage, mem_info

    def display_console_report(self):
        """Prints a regal Overwatch-style status report to the terminal."""
        cores, mem = self.get_stats()
        
        os.system('clear' if os.name == 'posix' else 'cls')
        print(">>> OVERWATCH SYSTEM RESOURCE MONITOR <<<")
        print(f"ACTIVE THREADS: {NUM_THREADS} | MEMORY LOAD: {mem:.2f} MB")
        print("-" * 40)
        
        # Display usage in a 4x6 grid for your 24 threads
        for i in range(0, len(cores), 4):
            row = cores[i:i+4]
            row_str = " | ".join([f"T{i+j:02d}: {usage:>5}%" for j, usage in enumerate(row)])
            print(row_str)
        print("-" * 40)
