import tkinter as tk
import random
from config import *

class FXEngine:
    def __init__(self, canvas):
        self.canvas = canvas

    def fire_shot(self, start_x, start_y, target_x, target_y, is_combine=True):
        """
        Creates a muzzle flash and a tracer bullet.
        Combine: White tracers (Regal)
        Resistance: Black tracers
        """
        bullet_color = "white" if is_combine else "black"
        flash_color = "yellow" if is_combine else "orange"
        
        # 1. Draw Muzzle Flash (Small star/oval)
        flash = self.canvas.create_oval(
            start_x-5, start_y-5, start_x+5, start_y+5, 
            fill=flash_color, outline="white"
        )
        
        # 2. Draw Tracer (A line from shooter toward target)
        # We calculate a short vector for the bullet path
        tracer = self.canvas.create_line(
            start_x, start_y, target_x, target_y, 
            fill=bullet_color, width=2, dash=(4, 4)
        )

        # 3. Schedule Deletion (Flash lasts 50ms, Tracer 100ms)
        self.canvas.after(50, lambda: self.canvas.delete(flash))
        self.canvas.after(100, lambda: self.canvas.delete(tracer))
