import struct

DATA_FORMAT = "qqqq"
ENTRY_SIZE = struct.calcsize(DATA_FORMAT)

def read_logs(filename="patrol_data.bin"):
    print(f"{'TIMESTAMP':<15} | {'UNIT':<5} | {'EVENT':<12} | {'VALUE':<5}")
    print("-" * 50)
    
    event_map = {1: "HIT", 2: "MORALE", 3: "ASSUME", 4: "BANDING"}

    try:
        with open(filename, "rb") as f:
            while True:
                chunk = f.read(ENTRY_SIZE)
                if not chunk:
                    break
                
                # Unpacking the signed long long ints
                t, uid, code, val = struct.unpack(DATA_FORMAT, chunk)
                event_name = event_map.get(code, "UNKNOWN")
                
                print(f"{t:<15} | {uid:<5} | {event_name:<12} | {val:<5}")
    except FileNotFoundError:
        print("No log file found. Start the patrol first!")

if __name__ == "__main__":
    read_logs()
