# config.py
WIDTH = 800
HEIGHT = 600
NUM_THREADS = 24

# Colors for the Overwatch
COLOR_COMBINE_BODY = "black"
COLOR_COMBINE_OUTLINE = "white"

# Colors for Civil Protection
COLOR_CP_BODY = "white"
COLOR_CP_OUTLINE = "white"

# Colors for Resistance
COLOR_RESISTANCE_BODY = "blue"
COLOR_RESISTANCE_OUTLINE = "yellow"

# SUBWAY STATION LAYOUT
# Obstacles (pillars, platforms, barriers)
OBSTACLES = [
    {"type": "pillar", "x": 200, "y": 150, "w": 40, "h": 40},
    {"type": "pillar", "x": 600, "y": 150, "w": 40, "h": 40},
    {"type": "pillar", "x": 200, "y": 450, "w": 40, "h": 40},
    {"type": "pillar", "x": 600, "y": 450, "w": 40, "h": 40},
    {"type": "platform", "x": 350, "y": 280, "w": 100, "h": 40},  # Central platform
    {"type": "barrier", "x": 100, "y": 300, "w": 80, "h": 15},
    {"type": "barrier", "x": 620, "y": 300, "w": 80, "h": 15},
]

# Resistance spawn points (entrances to the station)
RESISTANCE_SPAWNS = [
    {"name": "North Entrance", "x": 400, "y": 20},
    {"name": "East Tunnel", "x": 780, "y": 300},
    {"name": "South Stairs", "x": 400, "y": 580},
    {"name": "West Corridor", "x": 20, "y": 300},
]

# Combine spawn points (reinforcement dropships/secure corridors)
COMBINE_SPAWNS = [
    {"name": "Central Platform", "x": 400, "y": 300},  # Center station
    {"name": "West Secure Corridor", "x": 100, "y": 300},
    {"name": "East Secure Corridor", "x": 700, "y": 300},
]

# Defensive positions for Combine/CP (center of station)
DEFENSE_CENTER = (400, 300)
DEFENSE_RADIUS = 150

# Weapon damage values
WEAPON_DAMAGE = {
    "elite_rifle": (12, 22),  # Elites are superior - high damage
    "cp_pistol": (9, 16),     # CP equal to rebels now
    "rebel_smg": (9, 17),     # Rebels equal to CP
}

# Fire rate cooldowns (frames between shots)
FIRE_RATE = {
    "elite_rifle": 7,    # Elites shoot frequently and accurately
    "cp_pistol": 8,      # CP now similar fire rate to rebels
    "rebel_smg": 7,      # Rebels similar to CP
}

# Combat behavior
ELITE_RUSH_CHANCE = 0.15  # 15% chance per update to rush
ELITE_RUSH_DISTANCE = 200  # Rush if rebels within this distance

# Reinforcement spawning
MIN_ELITES = 4  # Minimum elites before spawning more
MIN_CP = 10     # Minimum CP before spawning more
MIN_REBELS = 8  # Minimum rebels before spawning more

MAX_ELITES = 12
MAX_CP = 30
MAX_REBELS = 35

ELITE_SPAWN_INTERVAL = (6, 10)  # Spawn every 6-10 seconds
CP_SPAWN_INTERVAL = (4, 8)      # Spawn every 4-8 seconds
REBEL_SPAWN_INTERVAL = (2, 5)   # Spawn every 2-5 seconds
