import struct

# Using 'q' for signed long long (8 bytes)
# Format: [Timestamp, UnitID, EventCode, Value]
DATA_FORMAT = "qqqq" 

class CombatLogger:
    def __init__(self, filename="patrol_data.bin"):
        self.filename = filename

    def log_event(self, timestamp, unit_id, event_code, value):
        """
        Saves a flattened binary entry.
        EventCodes: 1=Hit, 2=MoraleShift, 3=AssumePosition, 4=BandingUpdate
        """
        with open(self.filename, "ab") as f:
            # Packing the data into binary format
            binary_data = struct.pack(DATA_FORMAT, timestamp, unit_id, event_code, value)
            f.write(binary_data)

    def clear_logs(self):
        with open(self.filename, "wb") as f:
            f.truncate(0)
