import random
import math
from config import *
from quad_ai import QUAD_Brain

class CivilProtection:
    def __init__(self, uid, x, y):
        # The fix: Accept uid, x, and y
        self.id = uid
        self.x = x
        self.y = y
        
        # Stats for QUAD Logic - Now equal to Resistance
        self.health = 120  # Equal to rebels now (was 100)
        self.suppression = 0  # Crucial for the skirmish logic in main.py
        self.is_eager = True
        self.last_shot_frame = 0  # Fire rate cooldown
        
        # QUAD AI Brain
        self.brain = QUAD_Brain(faction="civil_protection")
        self.brain.grouping.weight = random.uniform(0.6, 0.8)  # CP like to stick together
        
        # Intelligence nodes (Memory of rebels)
        self.intel_nodes = []
        self.patrol_target = (random.randint(0, WIDTH), random.randint(0, HEIGHT))

    def patrol_logic(self):
        """
        Defensive patrol around the center of the station.
        CP units hold the perimeter.
        """
        # Calculate position relative to defense center
        dx_to_center = DEFENSE_CENTER[0] - self.x
        dy_to_center = DEFENSE_CENTER[1] - self.y
        dist_to_center = math.sqrt(dx_to_center**2 + dy_to_center**2)
        
        # Maintain defensive perimeter
        if dist_to_center > DEFENSE_RADIUS + 20:
            # Too far, move back
            dx = 2 if dx_to_center > 0 else -2
            dy = 2 if dy_to_center > 0 else -2
        elif dist_to_center < DEFENSE_RADIUS - 20:
            # Too close, move out
            dx = -1 if dx_to_center > 0 else 1
            dy = -1 if dy_to_center > 0 else 1
        else:
            # Good position, patrol in circle
            dx = random.choice([-1, 0, 1])
            dy = random.choice([-1, 0, 1])
            
        return dx, dy

    def add_suspicion(self, x, y):
        """
        QUAD Node creation: When they see a rebel, 
        they store the coordinate as a 'Suspicion' node.
        """
        self.intel_nodes.append({"pos": (x, y), "type": "Suspicion"})

    def encounter_elite(self, elite_unit, skirmish_engine):
        """
        The Handshake: Reporting intelligence to an Elite.
        This triggers the Elite to use its 'ASSUME' logic.
        """
        if self.intel_nodes:
            for node in self.intel_nodes:
                # CP units dump their memory into the Elite's QUAD pipeline
                elite_unit.receive_report(node, skirmish_engine)
            
            # Clear memory after reporting - mission accomplished
            self.intel_nodes = []
            return True
        return False

    def take_damage(self, amount):
        """Basic damage resolution."""
        self.health -= amount
        if self.health < 0: self.health = 0
